﻿using System;
using System.Xml;
using System.Windows.Forms;

namespace Dashlaunch_Translation_GUI
{
    public partial class Main : Form
    {
        ListViewItem item = null;
        bool orig;
        public Main()
        {
            InitializeComponent();
        }
        private void savestrings_Click(object sender, EventArgs e)
        {
            savefile.FileName = "strings.resx";
            savefile.Title = "Select where to save the translation";
            if (savefile.ShowDialog() == DialogResult.OK)
            {
                savexml(savefile.FileName);
            }
        }
        private void stringslist_DoubleClick(object sender, EventArgs e)
        {
            itemname.Text = items.SelectedItems[0].Text;
            original.Text = items.SelectedItems[0].SubItems[1].Text.Replace("\\n", Environment.NewLine);
            translation.Text = items.SelectedItems[0].SubItems[2].Text.Replace("\\n", Environment.NewLine);
        }
        private void parsexml(string file)
        {
            string name = "";
            bool exists = false;
            using (XmlReader xml = XmlReader.Create(file))
            {
                while (xml.Read())
                {
                    if (xml.IsStartElement())
                    {
                        switch (xml.Name.ToLower())
                        {
                            case "data":
                                name = xml["name"];
                                break;
                            case "value":
                                item = new ListViewItem();
                                item.Text = name;
                                xml.Read();
                                string value = xml.Value;
                                value = value.Replace("\n", "\\n");
                                exists = false;
                                foreach (ListViewItem obj in items.Items)
                                {
                                    if (obj.Text == name)
                                    {
                                        items.Items.Remove(obj);
                                        exists = true;
                                        if (orig)
                                        {
                                            item.SubItems.Add(value);
                                            item.SubItems.Add(obj.SubItems[2].Text);   
                                        }
                                        else if (!orig)
                                        {
                                            item.SubItems.Add(obj.SubItems[1].Text);
                                            item.SubItems.Add(value);
                                        }
                                    }
                                }
                                if ((!exists) && (orig))
                                {
                                    item.SubItems.Add(value);
                                    item.SubItems.Add("");
                                }
                                else if ((!exists) && (!orig))
                                {
                                    item.SubItems.Add("");
                                    item.SubItems.Add(value);
                                }
                                items.Items.Add(item);
                                break;
                            default:
                                break;
                        }
                    }
                }
            }
        }
        private void savexml(string file)
        {
            XmlWriterSettings settings = new XmlWriterSettings();
            settings.OmitXmlDeclaration = true;
            settings.ConformanceLevel = ConformanceLevel.Fragment;
            settings.Encoding = System.Text.Encoding.Unicode;
            using (XmlWriter xml = XmlWriter.Create(file, settings))
            {
                xml.WriteStartElement("root");
                xml.WriteWhitespace("\n");
                foreach (ListViewItem item in items.Items)
                {
                    xml.WriteStartElement("data");
                    xml.WriteStartAttribute("name");
                    xml.WriteValue(item.Text);
                    string value = item.SubItems[2].Text.Replace("\\n", Environment.NewLine);
                    if (string.IsNullOrEmpty(value)) { value = item.SubItems[1].Text.Replace("\\n", Environment.NewLine); }
                    xml.WriteElementString("value", value);
                    xml.WriteEndElement();
                    xml.WriteWhitespace("\n");
                }
                xml.WriteEndElement();
            }
        }
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)  { Close(); }
        private void savebtn_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem del in items.Items)
            {
                if (del.Text == itemname.Text) { items.Items.Remove(del); }
            }
            item = new ListViewItem();
            item.Text = itemname.Text;
            item.SubItems.Add(original.Text.Replace(Environment.NewLine, "\\n"));
            item.SubItems.Add(translation.Text.Replace(Environment.NewLine, "\\n"));
            items.Items.Add(item);
            itemname.Text = "";
            original.Text = "";
            translation.Text = "";
        }
        private void translation_TextChanged(object sender, EventArgs e)
        {
            savebtn.Enabled = ((translation.Text.Length > 0) && (itemname.Text.Length > 0));
        }
        private void copybtn_Click(object sender, EventArgs e)
        {
            translation.Text = original.Text;
        }
        private void loadorig_Click(object sender, EventArgs e)
        {
            loadfile.FileName = "strings.resx";
            loadfile.Title = "Select Original to load";
            if (loadfile.ShowDialog() == DialogResult.OK)
            {
                orig = true;
                parsexml(loadfile.FileName);
            }
        }
        private void loadtranslation_Click(object sender, EventArgs e)
        {
            loadfile.FileName = "strings.resx";
            loadfile.Title = "Select Translation to load";
            if (loadfile.ShowDialog() == DialogResult.OK)
            {
                orig = false;
                parsexml(loadfile.FileName);
            }
        }
        private void clearlist_Click(object sender, EventArgs e) { items.Items.Clear(); }
    }
}